/** @file   particlemanager.cpp
 * @brief   Implementation of ParticleManager - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "particlemanager.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
ParticleManager::ParticleManager() :
  Interactive()
{
}



/** Destructor
 */
ParticleManager::~ParticleManager()
{
  this->clear();
}




///
/// Public methods
/// ==============

/** Adds new particle system.
 */
void ParticleManager::addSystem( ParticleSystem* pPS )
{
  m_particleSystems.push_back( pPS );
}



/** updates the ParticleSystems
 */
void ParticleManager::update()
{
  for ( int i=0; i < m_particleSystems.size(); i++ ) {
    m_particleSystems.at(i)->update();
    if ( m_particleSystems.at(i)->m_activeParticleCount == 0 ) {
      // This particlesystem should be deleted.
      delete m_particleSystems.at(i);
      m_particleSystems.erase( m_particleSystems.begin() + i );
      i -= 1;
    }
  }
}



/** Destroyes all the particle systems
 */
void ParticleManager::clear()
{
  for ( int i=0; i < m_particleSystems.size(); i++ ) {
    delete m_particleSystems.at(i);
  }
  m_particleSystems.clear();
}



/** Redraws the the particle systems
 */
void ParticleManager::redraw( BITMAP* pB, const Vec2D& offset ) const
{
  for ( int i=0; i < m_particleSystems.size(); i++ ) {
    m_particleSystems.at(i)->redraw( pB, offset );
  }
}




///
/// Getter methods
/// ==============

/** Returns the number of particlesystems there are.
 */
int ParticleManager::systemCount() const
{
  return m_particleSystems.size();
}

} // end of namespace
